<?php

// main function to know the add-on existence and check if is active
function pcma_is_active() {
	if(!get_option('pcma_from_name') || !get_option('pcma_from_mail') || !get_option('pcma_reply_to_name') || !get_option('pcma_reply_to_mail')) {
		return false;
	}
	
	return true;
}





// replace the placeholders in the mail texts
function pcma_replace_placeholders($user_id, $txt, $user_data = false) {
	global $pc_users;
	
	
	// has to backup user session?
	//// setup a fake global var to allow shortcodes execution seamlessly - then restore the original value
	$us_to_backup = (isset($GLOBALS['pc_user_id'])) ? $GLOBALS['pc_user_id'] : false;
	$GLOBALS['pc_user_id'] = $user_id;
	
    $txt = pcma_replace_basic_placeholders($txt);
    
        
	// retrieve the user data
	if(!$user_data) {
		global $pc_users;
		$data = $pc_users->get_user($user_id, array('to_get' => array('name', 'surname', 'username', 'email', 'tel', 'categories')));
	}
	else {
        $data = $user_data;
    }

	// replace categories
	$cats = (strpos($txt, '%PC-CAT%') !== false) ? $pc_users->data_to_human('categories', $data['categories']) : '';

	$txt = str_replace(
		array('%NAME%', '%SURNAME%', '%USERNAME%', '%MAIL%', '%TEL%', '%PC-CAT%'),
		array($data['name'], $data['surname'], $data['username'], $data['email'], $data['tel'], $cats),
		$txt
	);
	
    
    // PCMA-FILTER - allow extra mail title/text treatment (eg. extra placeholders)
    $txt = apply_filters('pcma_extra_maiil_txt_manag', $txt, $user_id);
    
    
	// restore user session
	if($us_to_backup) {
		$GLOBALS['pc_user_id'] = $us_to_backup;	
	} else {
		unset($GLOBALS['pc_user_id']);	
	}
	
	return $txt;	
}





// replace placeholders (not related to a specific user) in the mail texts
function pcma_replace_basic_placeholders($txt) {
	$site_url_link = '<a href="'.get_site_url().'">'.get_site_url().'</a>';
	
	$txt = str_replace(
		array('%SITE-URL%', '%SITE-TITLE%', '%YEAR%'),
		array($site_url_link, str_replace('&amp;', '&', get_bloginfo('name')), date_i18n('Y')),
		$txt
	);

	// execute eventual shortcodes
	$txt = do_shortcode($txt);
    
	return $txt;	
}





// check if use SMTP for sending mails
function pcma_use_smtp() {
	$host  = get_option('pcma_smtp_host');
	$user  = get_option('pcma_smtp_user');
	$psw   = get_option('pcma_smtp_psw'); 
	
	if(
		get_option('pcma_use_smtp') && 
		!empty($host) &&
		!empty($user) &&
		!empty($psw)
	) {
		return array(
			'host' => $host,
			'user' => $user,
			'psw' => base64_decode($psw)
		);
	}
	else {
		return false;	
	}
}
	



// check if a user is certified via e-mail
function pcma_user_is_verified($id, $subj = 'user_id') {
	if($subj == 'user_id') {
		global $pc_users;
		$id = $pc_users->get_user_field($id, 'page_id');
	}
		
	return (get_post_meta($id, 'pcma_is_verified', true)) ? true : false;
}





// get e-mail templates as array (id => name) addi the first empty element for dropdowns
function pcma_get_mail_templates($prepend_none = true) {
	$terms = get_terms('pcma_mail_templates', 'hide_empty=0&orderby=name');
	$views = array(0 => '('. esc_html__('none', PCMA_ML) .')');
	
	if(is_wp_error($terms)) {
		return $views;	
	}
	
	foreach($terms as $term) {
		$views[ $term->term_id ] = $term->name;	
	}
	
	asort($views, SORT_NATURAL);
	return $views;
}





// apply e-mail template to a text
function pcma_apply_mail_templates($template_id, $mail_txt) {
	if(empty($template_id)) {
		return $mail_txt;	
	}
    
    // cached?
    if(!isset($GLOBALS['pcma_templates'])) {
        $GLOBALS['pcma_templates'] = array(); 
    }
    
    if(isset($GLOBALS['pcma_templates'][$template_id])) {
        $template = $GLOBALS['pcma_templates'][$template_id];   
    }
    else {
        $data = get_term_by('id', (int)$template_id, 'pcma_mail_templates');
        if(!$data) {
            return $mail_txt;	
        }

        $template = base64_decode($data->description);
        $template = str_replace(
            array(
                '%SITE-URL%', 
                '%SITE-TITLE%', 
                '%YEAR%'
            ),
            array(
                '<a href="'.get_site_url().'">'.get_site_url().'</a>', 
                str_replace('&amp;', '&', get_bloginfo('name')), 
                date('Y')
            ),
            $template
        );
        
        $GLOBALS['pcma_templates'][$template_id] = $template;
    }

    
    // wpautop if is not HTML
    $mail_txt = wpautop($mail_txt);
	return str_replace('%CONTENT%', $mail_txt, $template);
}





/*
 * Given a user ID, retrieves PvtContent Admin Users that might control it
 * @return (array) array(e-mail => nicename)
 */
function pcma_get_assoc_pc_admin_users($pc_user_id) {
    global $pc_users;
    $cats = $pc_users->get_user_field($pc_user_id, 'categories');
    
    $assoc = array();
    foreach($cats as $cat_id) {
        $cat_assoc = get_term_meta($cat_id, 'pg_ucat_manag_by_users', true);
        
        if(!empty($cat_assoc) && is_array($cat_assoc)) {
            $assoc = array_merge($assoc, $cat_assoc);
        }
    }
    
    $assoc = array_unique($assoc);
    $to_return = array();
    
    foreach($assoc as $wp_uid) {
        $udata = get_user_by('id', $wp_uid);
        $to_return[ $udata->user_email ] = $udata->user_nicename;
    }
    
    return $to_return;
}